import os
from qgis.core import QgsProject
from qgis.PyQt.QtWidgets import QMessageBox


class FileSetting:
    def __init__(self):
        self.text = None
        self.array_string = None
        self.array_int = None
        self.array_float = None
        self.expression = None
        self.section_min = None
        self.section_max = None
        self.numeric = None
        self.combo = None

    def set_text(self, value):
        
        self.text = value

    def set_expression(self, value):
        
        self.expression = value

    def set_array(self, string_value, int_value, float_value):
        
        self.array_string = string_value
        self.array_int = int_value
        self.array_float = float_value

    def set_section(self, section_min, section_max):
        
        self.section_min = section_min
        self.section_max = section_max

    def set_numeric(self, value):
        
        self.numeric = value

    def set_combo(self, value):
        
        self.combo = value

    def get_text(self):
        return self.text

    def get_expression(self):
        return self.expression

    def get_array(self):
        return (
            self.array_string,
            self.array_int,
            self.array_float,
        )

    def get_section(self):
        return (
            self.section_min,
            self.section_max,
        )

    def get_numeric(self):
        return self.numeric

    def get_combo(self):
        return self.combo

    def get_values(self):
        return (
            self.text,
            self.array_string,
            self.array_int,
            self.array_float,
            self.expression,
            self.section_min,
            self.section_max,
            self.numeric,
            self.combo
        )


class FileRecord:
    def __init__(self):
        
        self.file_type = None  

        self.file_path = {
            "shp": None,  
            "txt": None,  
            "csv": None,  
            "json": None,  
            "geojson": None,  
            "folder": None,  
            "layer": None,   
        }

        self.file_name = {
            "shp": None,  
            "txt": None,  
            "csv": None,  
            "json": None,  
            "geojson": None,  
            "folder": None,  
            "layer": None  
        }

    def set_record(self, file_type, file_path=None, file_name=None):
        
        if file_type not in self.file_path:
            QMessageBox.information(None, "오류", "지원하지 않는 파일 유형입니다.", QMessageBox.Ok)
            return  

        self.file_type = file_type

        self.file_path[file_type] = file_path

        
        if file_name is not None:
            self.file_name[file_type] = file_name

        elif file_path:
            self.file_name[file_type] = os.path.basename(file_path)

        else:
            self.file_name[file_type] = None

    def get_record(self):
        
        if self.file_type:
            return self.file_type, self.file_path.get(self.file_type), self.file_name.get(self.file_type)
        else:
            return None, None, None

    def get_file_type(self):
        
        if self.file_type:
            return self.file_type
        else:
            return None


class FilePreview:
    def __init__(self, file_path, file_encoding, file_delimiter, header_check, header, preview_rows, field_check, field_selection, file_uid, file_tuid):
        
        self.file_path = file_path  
        self.file_encoding = file_encoding  
        self.file_delimiter = file_delimiter  

        self.field_check = field_check  
        self.field_selection = field_selection  
        self.field_tracker = []  

        self.file_uid = file_uid  
        self.file_tuid = file_tuid  

        
        self.header_check = header_check  
        self.header = header  
        self.preview_rows = preview_rows  

    def get_info(self):
        return self.file_path, self.file_encoding, self.file_delimiter, self.header_check

    def get_file_name(self):
        return os.path.basename(self.file_path)

    def get_header(self):
        return self.header

    def get_preview_rows(self):
        return self.preview_rows

    def get_header_check(self):
        return self.header_check

    def get_file_encoding(self):
        return self.file_encoding

    def get_file_delimiter(self):
        return self.file_delimiter

    def get_field_check(self):
        return self.field_check

    def get_selection_field(self):
        return self.field_selection

    def get_file_uid(self):
        return self.file_uid

    def get_file_tuid(self):
        return self.file_tuid

    def set_field_check(self, field_check):
        self.field_check = field_check

    def set_selection_field(self, field_selection):
        self.field_selection = field_selection

    def set_file_uid(self, file_uid):
        self.file_uid = file_uid

    def set_file_tuid(self, file_tuid):
        self.file_tuid = file_tuid


class FileInfo:
    def __init__(self):
        
        self.file_record = FileRecord()  

        self.result_record = FileRecord()  
        self.result_field = None  
        self.result_table = {"header": None, "rows": None, "msg": None}  

        self.file_setting = FileSetting()  

        
        self.file_preview = []  
        self.file_preview_index = 0   

    def get_preview_file_type(self, preview_index=0):
        
        file_type = self.file_record.get_file_type()
        if file_type == 'folder':
            file_type = self.file_preview[preview_index].file_path.split('.')[-1].lower()
        return file_type

    def get_summary(self):
        
        summary = []
        file_type, file_path, file_name = self.file_record.get_record()
        summary.append(f"파일 유형: {file_type}")
        summary.append(f"파일 경로: {file_path}")
        summary.append(f"파일 이름: {file_name}\n")

        text, array_string, array_int, array_float, expression, section_min, section_max, numeric, combo = self.file_setting.get_values()
        summary.append(f"설정 작업값: {text}")
        summary.append(f"설정 초기값(string): {array_string}")
        summary.append(f"설정 초기값(integer): {array_int}")
        summary.append(f"설정 초기값(float): {array_float}")
        summary.append(f"결과 조건부: {expression}")
        summary.append(f"설정 최소값: {section_min}")
        summary.append(f"설정 최대값: {section_max}")
        summary.append(f"설정 수치값: {numeric}")
        summary.append(f"설정 리스트값: {combo}\n")

        file_type, file_path, file_name = self.result_record.get_record()
        summary.append(f"결과 유형: {file_type}")
        summary.append(f"결과 경로: {file_path}")
        summary.append(f"결과 이름: {file_name}")
        summary.append(f"결과 필더: {self.result_field}\n")

        
        if self.file_preview:
            for index, file_preview in enumerate(self.file_preview):
                summary.append(f"미리보기 테이블 ({index + 1}):")
                summary.append(f"경로: {file_preview.file_path}")
                summary.append(f"인코딩: {file_preview.file_encoding}")

                summary.append(f"헤드 유무: {file_preview.header_check}")
                summary.append(f"구분자: {file_preview.file_delimiter}")

                summary.append(f"UID: {file_preview.file_uid}")
                summary.append(f"TUID: {file_preview.file_tuid}")

                summary.append(f"필더 범위 체크: {file_preview.field_check}")
                header_strings = ", ".join(file_preview.field_selection)  
                summary.append(f"필더 범위: {header_strings}")

                header_strings = ", ".join(file_preview.header)   
                summary.append(f"헤더 :{header_strings}")

                
                

        return "\n".join(summary)


